unit DockMan_U;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    components: System.ComponentModel.IContainer;
    Panel1: System.Windows.Forms.Panel;
    Panel2: System.Windows.Forms.Panel;
    GroupBox1: System.Windows.Forms.GroupBox;
    GroupBox2: System.Windows.Forms.GroupBox;
    btnDemo: System.Windows.Forms.Button;
    chkTop: System.Windows.Forms.CheckBox;
    chkLeft: System.Windows.Forms.CheckBox;
    chkBottom: System.Windows.Forms.CheckBox;
    chkRight: System.Windows.Forms.CheckBox;
    rdbNone: System.Windows.Forms.RadioButton;
    rdbTop: System.Windows.Forms.RadioButton;
    rdbLeft: System.Windows.Forms.RadioButton;
    rdbBottom: System.Windows.Forms.RadioButton;
    rdbRight: System.Windows.Forms.RadioButton;
    rdbFill: System.Windows.Forms.RadioButton;
    rdbSet: System.Windows.Forms.RadioButton;
    ToolTip1: System.Windows.Forms.ToolTip;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TWinForm_Activated(sender: System.Object; e: System.EventArgs);
    procedure rdbNone_Click(sender: System.Object; e: System.EventArgs);
    procedure chkTop_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    procedure ApplyChanges;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.components := System.ComponentModel.Container.Create;
  Self.Panel1 := System.Windows.Forms.Panel.Create;
  Self.btnDemo := System.Windows.Forms.Button.Create;
  Self.Panel2 := System.Windows.Forms.Panel.Create;
  Self.rdbSet := System.Windows.Forms.RadioButton.Create;
  Self.GroupBox2 := System.Windows.Forms.GroupBox.Create;
  Self.rdbFill := System.Windows.Forms.RadioButton.Create;
  Self.rdbRight := System.Windows.Forms.RadioButton.Create;
  Self.rdbBottom := System.Windows.Forms.RadioButton.Create;
  Self.rdbLeft := System.Windows.Forms.RadioButton.Create;
  Self.rdbTop := System.Windows.Forms.RadioButton.Create;
  Self.rdbNone := System.Windows.Forms.RadioButton.Create;
  Self.GroupBox1 := System.Windows.Forms.GroupBox.Create;
  Self.chkRight := System.Windows.Forms.CheckBox.Create;
  Self.chkBottom := System.Windows.Forms.CheckBox.Create;
  Self.chkLeft := System.Windows.Forms.CheckBox.Create;
  Self.chkTop := System.Windows.Forms.CheckBox.Create;
  Self.ToolTip1 := System.Windows.Forms.ToolTip.Create(Self.components);
  Self.Panel1.SuspendLayout;
  Self.Panel2.SuspendLayout;
  Self.GroupBox2.SuspendLayout;
  Self.GroupBox1.SuspendLayout;
  Self.SuspendLayout;
  // 
  // Panel1
  // 
  Self.Panel1.BackColor := System.Drawing.SystemColors.InactiveCaptionText;
  Self.Panel1.BorderStyle := System.Windows.Forms.BorderStyle.Fixed3D;
  Self.Panel1.Controls.Add(Self.btnDemo);
  Self.Panel1.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.Panel1.Location := System.Drawing.Point.Create(0, 0);
  Self.Panel1.Name := 'Panel1';
  Self.Panel1.Size := System.Drawing.Size.Create(480, 438);
  Self.Panel1.TabIndex := 0;
  // 
  // btnDemo
  // 
  Self.btnDemo.BackColor := System.Drawing.SystemColors.ActiveCaptionText;
  Self.btnDemo.Location := System.Drawing.Point.Create(264, 160);
  Self.btnDemo.Name := 'btnDemo';
  Self.btnDemo.Size := System.Drawing.Size.Create(104, 23);
  Self.btnDemo.TabIndex := 0;
  Self.btnDemo.Text := 'Demo Button';
  // 
  // Panel2
  // 
  Self.Panel2.BorderStyle := System.Windows.Forms.BorderStyle.Fixed3D;
  Self.Panel2.Controls.Add(Self.rdbSet);
  Self.Panel2.Controls.Add(Self.GroupBox2);
  Self.Panel2.Controls.Add(Self.GroupBox1);
  Self.Panel2.Dock := System.Windows.Forms.DockStyle.Left;
  Self.Panel2.Location := System.Drawing.Point.Create(0, 0);
  Self.Panel2.Name := 'Panel2';
  Self.Panel2.Size := System.Drawing.Size.Create(168, 438);
  Self.Panel2.TabIndex := 1;
  // 
  // rdbSet
  // 
  Self.rdbSet.Location := System.Drawing.Point.Create(32, 408);
  Self.rdbSet.Name := 'rdbSet';
  Self.rdbSet.TabIndex := 2;
  Self.rdbSet.Text := 'RadioButton1';
  Self.rdbSet.Visible := False;
  // 
  // GroupBox2
  // 
  Self.GroupBox2.BackColor := System.Drawing.Color.WhiteSmoke;
  Self.GroupBox2.Controls.Add(Self.rdbFill);
  Self.GroupBox2.Controls.Add(Self.rdbRight);
  Self.GroupBox2.Controls.Add(Self.rdbBottom);
  Self.GroupBox2.Controls.Add(Self.rdbLeft);
  Self.GroupBox2.Controls.Add(Self.rdbTop);
  Self.GroupBox2.Controls.Add(Self.rdbNone);
  Self.GroupBox2.Location := System.Drawing.Point.Create(18, 168);
  Self.GroupBox2.Name := 'GroupBox2';
  Self.GroupBox2.Size := System.Drawing.Size.Create(118, 231);
  Self.GroupBox2.TabIndex := 1;
  Self.GroupBox2.TabStop := False;
  Self.GroupBox2.Text := 'Dock';
  // 
  // rdbFill
  // 
  Self.rdbFill.Location := System.Drawing.Point.Create(16, 144);
  Self.rdbFill.Name := 'rdbFill';
  Self.rdbFill.Size := System.Drawing.Size.Create(72, 24);
  Self.rdbFill.TabIndex := 5;
  Self.rdbFill.Text := 'Fill';
  Include(Self.rdbFill.Click, Self.rdbNone_Click);
  // 
  // rdbRight
  // 
  Self.rdbRight.Location := System.Drawing.Point.Create(16, 120);
  Self.rdbRight.Name := 'rdbRight';
  Self.rdbRight.Size := System.Drawing.Size.Create(72, 24);
  Self.rdbRight.TabIndex := 4;
  Self.rdbRight.Text := 'Right';
  Include(Self.rdbRight.Click, Self.rdbNone_Click);
  // 
  // rdbBottom
  // 
  Self.rdbBottom.Location := System.Drawing.Point.Create(16, 96);
  Self.rdbBottom.Name := 'rdbBottom';
  Self.rdbBottom.Size := System.Drawing.Size.Create(72, 24);
  Self.rdbBottom.TabIndex := 3;
  Self.rdbBottom.Text := 'Bottom';
  Include(Self.rdbBottom.Click, Self.rdbNone_Click);
  // 
  // rdbLeft
  // 
  Self.rdbLeft.Location := System.Drawing.Point.Create(16, 72);
  Self.rdbLeft.Name := 'rdbLeft';
  Self.rdbLeft.Size := System.Drawing.Size.Create(72, 24);
  Self.rdbLeft.TabIndex := 2;
  Self.rdbLeft.Text := 'Left';
  Include(Self.rdbLeft.Click, Self.rdbNone_Click);
  // 
  // rdbTop
  // 
  Self.rdbTop.Location := System.Drawing.Point.Create(16, 48);
  Self.rdbTop.Name := 'rdbTop';
  Self.rdbTop.Size := System.Drawing.Size.Create(72, 24);
  Self.rdbTop.TabIndex := 1;
  Self.rdbTop.Text := 'Top';
  Include(Self.rdbTop.Click, Self.rdbNone_Click);
  // 
  // rdbNone
  // 
  Self.rdbNone.Checked := True;
  Self.rdbNone.Location := System.Drawing.Point.Create(16, 24);
  Self.rdbNone.Name := 'rdbNone';
  Self.rdbNone.Size := System.Drawing.Size.Create(72, 24);
  Self.rdbNone.TabIndex := 0;
  Self.rdbNone.TabStop := True;
  Self.rdbNone.Text := 'None';
  Include(Self.rdbNone.Click, Self.rdbNone_Click);
  // 
  // GroupBox1
  // 
  Self.GroupBox1.BackColor := System.Drawing.Color.WhiteSmoke;
  Self.GroupBox1.Controls.Add(Self.chkRight);
  Self.GroupBox1.Controls.Add(Self.chkBottom);
  Self.GroupBox1.Controls.Add(Self.chkLeft);
  Self.GroupBox1.Controls.Add(Self.chkTop);
  Self.GroupBox1.Location := System.Drawing.Point.Create(16, 24);
  Self.GroupBox1.Name := 'GroupBox1';
  Self.GroupBox1.Size := System.Drawing.Size.Create(120, 128);
  Self.GroupBox1.TabIndex := 0;
  Self.GroupBox1.TabStop := False;
  Self.GroupBox1.Text := 'Anchor';
  // 
  // chkRight
  // 
  Self.chkRight.Location := System.Drawing.Point.Create(16, 96);
  Self.chkRight.Name := 'chkRight';
  Self.chkRight.Size := System.Drawing.Size.Create(80, 24);
  Self.chkRight.TabIndex := 3;
  Self.chkRight.Text := 'Right';
  Include(Self.chkRight.Click, Self.chkTop_Click);
  // 
  // chkBottom
  // 
  Self.chkBottom.Location := System.Drawing.Point.Create(16, 72);
  Self.chkBottom.Name := 'chkBottom';
  Self.chkBottom.Size := System.Drawing.Size.Create(80, 24);
  Self.chkBottom.TabIndex := 2;
  Self.chkBottom.Text := 'Bottom';
  Include(Self.chkBottom.Click, Self.chkTop_Click);
  // 
  // chkLeft
  // 
  Self.chkLeft.Location := System.Drawing.Point.Create(16, 48);
  Self.chkLeft.Name := 'chkLeft';
  Self.chkLeft.Size := System.Drawing.Size.Create(80, 24);
  Self.chkLeft.TabIndex := 1;
  Self.chkLeft.Text := 'Left';
  Include(Self.chkLeft.Click, Self.chkTop_Click);
  // 
  // chkTop
  // 
  Self.chkTop.Location := System.Drawing.Point.Create(16, 24);
  Self.chkTop.Name := 'chkTop';
  Self.chkTop.Size := System.Drawing.Size.Create(80, 24);
  Self.chkTop.TabIndex := 0;
  Self.chkTop.Text := 'Top';
  Include(Self.chkTop.Click, Self.chkTop_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(480, 438);
  Self.Controls.Add(Self.Panel2);
  Self.Controls.Add(Self.Panel1);
  Self.Name := 'TWinForm';
  Self.Text := 'Docking and Anchoring Example';
  Include(Self.Activated, Self.TWinForm_Activated);
  Self.Panel1.ResumeLayout(False);
  Self.Panel2.ResumeLayout(False);
  Self.GroupBox2.ResumeLayout(False);
  Self.GroupBox1.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.chkTop_Click(sender: System.Object; e: System.EventArgs);
begin
  ApplyChanges;
end;

procedure TWinForm.rdbNone_Click(sender: System.Object; e: System.EventArgs);
begin
  rdbSet:= RadioButton(sender);
  ApplyChanges;
end;

procedure TWinForm.TWinForm_Activated(sender: System.Object; e: System.EventArgs);
begin
  ToolTip1.SetToolTip (btnDemo, 'Nothing happens if you click this button; resize the form to see the layout effects.');
  Panel1.BackColor := Color.get_Green();
end;

procedure TWinForm.ApplyChanges;
var
  nSettings: AnchorStyles;
begin
  //Apply Anchoring Settings - maybe multiple
  nSettings:= AnchorStyles.None;

  // Compiler still does not have the notion of sets!!!
  if (chkTop.Checked) then
    nSettings:= AnchorStyles(Integer(nSettings)+ Integer(AnchorStyles.Top));
  if (chkLeft.Checked) then
    nSettings:= AnchorStyles(Integer(nSettings)+ Integer(AnchorStyles.Left));
  if (chkBottom.Checked) then
    nSettings:= AnchorStyles(Integer(nSettings)+ Integer(AnchorStyles.Bottom));
  if (chkRight.Checked) then
    nSettings:= AnchorStyles(Integer(nSettings)+ Integer(AnchorStyles.Right));

  btnDemo.Anchor:= nSettings;

  //Apply Docking settings - one only
  if (rdbSet = rdbNone) then
      btnDemo.Dock:= DockStyle.None
  else if (rdbSet = rdbTop) then
    btnDemo.Dock:= DockStyle.Top
  else if (rdbSet = rdbLeft) then
    btnDemo.Dock:= DockStyle.Left
  else if (rdbSet = rdbBottom) then
    btnDemo.Dock:= DockStyle.Bottom
  else if (rdbSet = rdbRight) then
    btnDemo.Dock:= DockStyle.Right
  else // The default is: if (rdbSet is rbFill)
    btnDemo.Dock:= DockStyle.Fill;
end;

end.
